//=============================================================================
// SpawnTrigger
//
// You can spawn actors straight into the player's inventory, or on the map 
// where the trigger itself is
//
// A spawnedLifespan of 0 means it will never just despawn
//
// spawnedActorEventTag sets the event tag on the actor you spawned (useful for
// things like helicopter travel in coop missions)
//=============================================================================
Class SpawnTrigger extends MPConvo_Trigger;

var(MPC_SpawnTrigger) class<Actor> spawnActor;
var(MPC_SpawnTrigger) bool bSpawnInInventory;
var(MPC_SpawnTrigger) int spawnedLifespan;
var(MPC_SpawnTrigger) name spawnedActorEventTag;
var(MPC_SpawnTrigger) bool onlySpawnOnceForCOOP;
var float coolDownSilly;

function DoCoolStuff(DeusExPlayer Instigator)
{
	local Actor sA;

	if(onlySpawnOnceForCOOP == true)
	{
		coolDownSilly = Level.TimeSeconds + 2.0; //small cooldown; stops a foreach from doing this lots of times (example: noisy stacked helicopters)
	}

	if(Level.TimeSeconds >= coolDownSilly)
	{
		if(bSpawnInInventory == true)
		{
			sA = Spawn(spawnActor);
			sA.Frob(Instigator,None);
		}
		else
		{
			sA = Spawn(spawnActor,,, Location, Rotation);
			sA.lifespan = spawnedLifespan;
		}


		if((sA.IsA('DeusExWeapon')) || (sA.IsA('DeusExItem'))) //dx inventory things
		{
			if(sA.Owner == None) //if we're on MP, we've just copied the item. In that case, destroy the original
			{
				sA.Destroy();
			}
		}

		sA.Event = spawnedActorEventTag;
	}
}

defaultproperties
{
     bSpawnInInventory=true
}